/*
 * Decompiled with CFR 0.152.
 */
package com.andavin.util;

import java.util.function.Consumer;
import java.util.logging.Level;

public final class Logger {
    private static java.util.logging.Logger logger = java.util.logging.Logger.getLogger("");

    public static void initialize(java.util.logging.Logger logger) throws IllegalStateException {
        Logger.logger = logger;
    }

    public static void info(Object obj) {
        logger.log(Level.INFO, obj.toString());
    }

    public static void info(String msg) {
        logger.log(Level.INFO, msg);
    }

    public static void info(String msg, Object ... args) {
        logger.log(Level.INFO, Logger.format(msg, args));
    }

    public static void info(Throwable throwable, String msg, Object ... args) {
        logger.log(Level.INFO, Logger.format(msg, args), throwable);
    }

    public static void info(Throwable throwable) {
        logger.log(Level.INFO, throwable.getMessage(), throwable);
    }

    public static void warn(Object obj) {
        logger.log(Level.WARNING, obj.toString());
    }

    public static void warn(String msg) {
        logger.log(Level.WARNING, msg);
    }

    public static void warn(String msg, Object ... args) {
        logger.log(Level.WARNING, Logger.format(msg, args));
    }

    public static void warn(Throwable throwable, String msg, Object ... args) {
        logger.log(Level.WARNING, Logger.format(msg, args), throwable);
    }

    public static void warn(Throwable throwable) {
        logger.log(Level.WARNING, throwable.getMessage(), throwable);
    }

    public static void severe(Object obj) {
        logger.log(Level.SEVERE, obj.toString());
    }

    public static void severe(String msg, Object ... args) {
        logger.log(Level.SEVERE, Logger.format(msg, args));
    }

    public static void severe(Throwable throwable, String msg, Object ... args) {
        logger.log(Level.SEVERE, Logger.format(msg, args), throwable);
    }

    public static void severe(Throwable throwable) {
        logger.log(Level.SEVERE, throwable.getMessage(), throwable);
    }

    public static void debug(Object obj) {
        logger.log(Level.CONFIG, obj.toString());
    }

    public static void debug(String msg) {
        logger.log(Level.CONFIG, msg);
    }

    public static void debug(String msg, Object ... args) {
        logger.log(Level.CONFIG, Logger.format(msg, args));
    }

    public static void debug(Throwable throwable, String msg, Object ... args) {
        logger.log(Level.CONFIG, Logger.format(msg, args), throwable);
    }

    public static void debug(Throwable throwable) {
        logger.log(Level.CONFIG, throwable.getMessage(), throwable);
    }

    public static void handle(Throwable throwable, Consumer<String> handler) throws RuntimeException {
        Logger.handle(throwable, handler, false);
    }

    public static void handle(Throwable throwable, Consumer<String> handler, boolean log) throws RuntimeException {
        String message = throwable.getMessage();
        if (message != null && message.trim().charAt(0) == '\u00a7') {
            handler.accept(message);
            return;
        }
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            message = cause.getMessage();
            if (message == null || message.trim().charAt(0) != '\u00a7') continue;
            handler.accept(message);
            return;
        }
        handler.accept("\u00a7cAn error has occurred during command execution.");
        if (!log) {
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
        Logger.severe(throwable);
    }

    public static String format(String message, Object ... arguments) {
        if (arguments == null || arguments.length == 0) {
            return message;
        }
        int start = 0;
        int argumentIndex = 0;
        int openBraces = 0;
        StringBuilder builder = new StringBuilder(message.length() + arguments.length * 16);
        for (int index = 0; index < message.length(); ++index) {
            char character = message.charAt(index);
            if (character == '{') {
                if (openBraces++ != 0 || start >= index) continue;
                builder.append(message, start, index);
                start = index;
                continue;
            }
            if (character != '}' || openBraces <= 0 || --openBraces != 0) continue;
            if (argumentIndex < arguments.length) {
                Object argument = arguments[argumentIndex++];
                if (index == start + 1) {
                    builder.append(argument);
                } else {
                    builder.append(Logger.format(message.substring(start + 1, index), argument));
                }
            } else {
                builder.append(message, start, index + 1);
            }
            start = index + 1;
        }
        if (start < message.length()) {
            builder.append(message, start, message.length());
        }
        return builder.toString();
    }
}

